/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id:  $:

  Description:
    Definition file of the cifX API library class

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2006-06-28  initial version

**************************************************************************************/

#pragma once

#include <stdint.h>
#include "cifXUser.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// \file cifXAPIlib.h
///  Definition file of the cifX API library class
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
/// cifX API library class
///////////////////////////////////////////////////////////////////////////////////////////
class CCifXAPIlib
{
public:
       CCifXAPIlib            ( void);
       ~CCifXAPIlib           ( void);

  bool Valid                     ( void);
  void SetSelected               ( bool);
  bool GetSelected               ( void);
  void SetRemoteAPI              ( void);
  bool IsRemoteAPI               ( void);

  /* Driver functions */
  int32_t DriverOpen             ( char* szFileName );
  int32_t DriverClose            ( void);
  int32_t DriverEnumBoards       ( uint32_t ulBoard, uint32_t ulSize, void* pvBoardInfo);
  int32_t DriverEnumChannels     ( uint32_t ulBoard, uint32_t ulChannel, uint32_t ulSize, void* pvChannelInfo);
  int32_t DriverMemoryPointer    ( uint32_t ulBoard, uint32_t ulCmd,void* pvMemoryInfo);
  int32_t DriverRestartDevice    ( char* szBoardName, void* pvData);
  int32_t SysdeviceOpen          ( char* szBoard, CIFXHANDLE* phSysdevice);
  int32_t ChannelOpen            ( char* szBoard, uint32_t ulChannel, CIFXHANDLE* phChannel);

  DRIVER_INFORMATION DriverGetInformation ( void);

  /* Global driver functions */
  typedef int32_t (APIENTRY *X_DRIVER_OPEN )                 ( CIFXHANDLE* phDriver);
  typedef int32_t (APIENTRY *X_DRIVER_CLOSE )                ( CIFXHANDLE  hDriver);
  typedef int32_t (APIENTRY *X_DRIVER_GET_INFORMATION )      ( CIFXHANDLE  hDriver, uint32_t ulSize, void* pvDriverInfo);
  typedef int32_t (APIENTRY *X_DRIVER_GET_ERROR_DESCRIPTION )( int32_t        lError, char* szBuffer, uint32_t ulBufferLen);
  typedef int32_t (APIENTRY *X_DRIVER_ENUM_BOARDS )          ( CIFXHANDLE  hDriver, uint32_t ulBoard, uint32_t ulSize, void* pvBoardInfo);
  typedef int32_t (APIENTRY *X_DRIVER_ENUM_CHANNELS )        ( CIFXHANDLE  hDriver, uint32_t ulBoard, uint32_t ulChannel, uint32_t ulSize, void* pvChannelInfo);
  typedef int32_t (APIENTRY *X_DRIVER_MEMORY_POINTER )       ( CIFXHANDLE  hDriver, uint32_t ulBoard, uint32_t ulCmd,void* pvMemoryInfo);
  typedef int32_t (APIENTRY *X_DRIVER_RESTART_DEVICE )       ( CIFXHANDLE  hDriver, char* szBoardName,     void* pvData);

  /* System device depending functions */
  typedef int32_t (APIENTRY *X_SYSDEVICE_OPEN )              ( CIFXHANDLE  hDriver, char*   szBoard, CIFXHANDLE* phSysdevice);
  typedef int32_t (APIENTRY *X_SYSDEVICE_CLOSE )             ( CIFXHANDLE  hSysdevice);
  typedef int32_t (APIENTRY *X_SYSDEVICE_GET_MBX_STATE )     ( CIFXHANDLE  hSysdevice, uint32_t* pulRecvPktCount, uint32_t* pulSendPktCount);
  typedef int32_t (APIENTRY *X_SYSDEVICE_PUT_PACKET )        ( CIFXHANDLE  hSysdevice, CIFX_PACKET* ptSendPkt, uint32_t ulTimeout);
  typedef int32_t (APIENTRY *X_SYSDEVICE_GET_PACKET )        ( CIFXHANDLE  hSysdevice, uint32_t ulSize, CIFX_PACKET* ptRecvPkt, uint32_t ulTimeout);
  typedef int32_t (APIENTRY *X_SYSDEVICE_INFO )              ( CIFXHANDLE  hSysdevice, uint32_t ulCmd, uint32_t ulSize, void* pvInfo);
  typedef int32_t (APIENTRY *X_SYSDEVICE_FIND_FIRST_FILE )   ( CIFXHANDLE  hSysdevice, uint32_t ulChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);
  typedef int32_t (APIENTRY *X_SYSDEVICE_FIND_NEXT_FILE )    ( CIFXHANDLE  hSysdevice, uint32_t ulChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);
  typedef int32_t (APIENTRY *X_SYSDEVICE_DOWNLOAD )          ( CIFXHANDLE  hSysdevice, uint32_t ulChannel, uint32_t ulMode, char* pszFileName, unsigned char* pabFileData, uint32_t ulFileSize,
                                                                      PFN_PROGRESS_CALLBACK pfnCallback, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);
  typedef int32_t (APIENTRY *X_SYSDEVICE_UPLOAD )            ( CIFXHANDLE  hSysdevice, uint32_t ulChannel, uint32_t ulMode, char* pszFileName, unsigned char* pabFileData, uint32_t* pulFileSize,
                                                                      PFN_PROGRESS_CALLBACK pfnCallback, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);
  typedef int32_t (APIENTRY *X_SYSDEVICE_RESET )             ( CIFXHANDLE  hSysdevice, uint32_t ulTimeout);

  /* Channel depending functions */
  typedef int32_t (APIENTRY *X_CHANNEL_OPEN )                  ( CIFXHANDLE  hDriver,  char* szBoard, uint32_t ulChannel, CIFXHANDLE* phChannel);
  typedef int32_t (APIENTRY *X_CHANNEL_CLOSE )                 ( CIFXHANDLE  hChannel);
  typedef int32_t (APIENTRY *X_CHANNEL_FIND_FIRST_FILE )       ( CIFXHANDLE  hChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);
  typedef int32_t (APIENTRY *X_CHANNEL_FIND_NEXT_FILE )        ( CIFXHANDLE  hChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);
  typedef int32_t (APIENTRY *X_CHANNEL_DOWNLOAD )              ( CIFXHANDLE  hChannel, uint32_t ulMode, char* pszFileName, unsigned char* pabFileData, uint32_t ulFileSize,
                                                                    PFN_PROGRESS_CALLBACK pfnCallback, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);
  typedef int32_t (APIENTRY *X_CHANNEL_UPLOAD )                ( CIFXHANDLE  hChannel, uint32_t ulMode, char* pszFileName, unsigned char* pabFileData, uint32_t* pulFileSize,
                                                                    PFN_PROGRESS_CALLBACK pfnCallback, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);
  typedef int32_t (APIENTRY *X_CHANNEL_GET_MBX_STATE )         ( CIFXHANDLE  hChannel, uint32_t* pulRecvPktCount, uint32_t* pulSendPktCount);
  typedef int32_t (APIENTRY *X_CHANNEL_PUT_PACKET )            ( CIFXHANDLE  hChannel, CIFX_PACKET*  ptSendPkt, uint32_t ulTimeout);
  typedef int32_t (APIENTRY *X_CHANNEL_GET_PACKET )            ( CIFXHANDLE  hChannel, uint32_t ulSize, CIFX_PACKET* ptRecvPkt, uint32_t ulTimeout);
  typedef int32_t (APIENTRY *X_CHANNEL_GET_SEND_PACKET )       ( CIFXHANDLE  hChannel, uint32_t ulSize, CIFX_PACKET* ptRecvPkt);
  typedef int32_t (APIENTRY *X_CHANNEL_CONFIG_LOCK )           ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t* pulState, uint32_t ulTimeout);
  typedef int32_t (APIENTRY *X_CHANNEL_RESET )                 ( CIFXHANDLE  hChannel, uint32_t ulResetMode, uint32_t ulTimeout);
  typedef int32_t (APIENTRY *X_CHANNEL_INFO )                  ( CIFXHANDLE  hChannel, uint32_t ulSize, void* pvChannelInfo);
  typedef int32_t (APIENTRY *X_CHANNEL_WATCHDOG )              ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t* pulTrigger);
  typedef int32_t (APIENTRY *X_CHANNEL_HOST_STATE )            ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t* pulState, uint32_t ulTimeout);
  typedef int32_t (APIENTRY *X_CHANNEL_BUS_STATE )             ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t* pulState, uint32_t ulTimeout);
  typedef int32_t (APIENTRY *X_CHANNEL_DMA_STATE )             ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t* pulState);

  typedef int32_t (APIENTRY *X_CHANNEL_IOINFO )                ( CIFXHANDLE  hChannel, uint32_t ulCmd,        uint32_t ulAreaNumber, uint32_t ulSize, void* pvData);
  typedef int32_t (APIENTRY *X_CHANNEL_IOREAD )                ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber, uint32_t ulOffset,     uint32_t ulDataLen, void* pvData, uint32_t ulTimeout);
  typedef int32_t (APIENTRY *X_CHANNEL_IOWRITE )               ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber, uint32_t ulOffset,     uint32_t ulDataLen, void* pvData, uint32_t ulTimeout);
  typedef int32_t (APIENTRY *X_CHANNEL_IOREAD_SEND_DATA )      ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber, uint32_t ulOffset,     uint32_t ulDataLen, void* pvData);
  typedef int32_t (APIENTRY *X_CHANNEL_CONTROL_BLOCK )         ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t ulOffset, uint32_t ulDataLen, void* pvData);
  typedef int32_t (APIENTRY *X_CHANNEL_COMMON_STATUS_BLOCK )   ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t ulOffset, uint32_t ulDataLen, void* pvData);
  typedef int32_t (APIENTRY *X_CHANNEL_EXTENDED_STATUS_BLOCK ) ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t ulOffset, uint32_t ulDataLen, void* pvData);
  typedef int32_t (APIENTRY *X_CHANNEL_USER_BLOCK )            ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber, uint32_t ulCmd, uint32_t ulOffset, uint32_t ulDataLen, void* pvData);
  typedef int32_t (APIENTRY *X_CHANNEL_PLC_MEMORYPTR )         ( CIFXHANDLE  hChannel, uint32_t ulCmd,        void* pvMemoryInfo);
  typedef int32_t (APIENTRY *X_CHANNEL_PLC_IS_READ_READY )     ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber, uint32_t* pulReadState);
  typedef int32_t (APIENTRY *X_CHANNEL_PLC_IS_WRITE_READY )    ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber, uint32_t* pulWriteState);
  typedef int32_t (APIENTRY *X_CHANNEL_PLC_ACTIVATE_WRITE )    ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber);
  typedef int32_t (APIENTRY *X_CHANNEL_PLC_ACTIVATE_READ )     ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber);

  typedef int32_t (APIENTRY *NX_CON_CREATE_CONFIG_DIALOG )     ( char* szUUID, void* pvParentWnd, void** pvDialogWnd);
  typedef int32_t (APIENTRY *NX_CON_CLOSE_CONFIG_DIALOG )      ( char* szUUID, BOOL fSaveChanges);
  typedef int32_t (APIENTRY *NX_CON_ENUMERATE )                ( uint32_t ulConnectorIdx, uint32_t ulSize, void* pvConnectorInfo);

  HMODULE                        m_hDll;
  CIFXHANDLE                     m_hDriver;
  long                           m_lError;
  bool                           m_fSelected;
  bool                           m_fRemoteAPI;

  /* Global driver functions */
  X_DRIVER_OPEN                  xDriverOpen;
  X_DRIVER_CLOSE                 xDriverClose;
  X_DRIVER_GET_INFORMATION       xDriverGetInformation;
  X_DRIVER_GET_ERROR_DESCRIPTION xDriverGetErrorDescription;
  X_DRIVER_ENUM_BOARDS           xDriverEnumBoards;
  X_DRIVER_ENUM_CHANNELS         xDriverEnumChannels;
  X_DRIVER_MEMORY_POINTER        xDriverMemoryPointer;
  X_DRIVER_RESTART_DEVICE        xDriverRestartDevice;

  /* System device depending functions */
  X_SYSDEVICE_OPEN               xSysdeviceOpen;
  X_SYSDEVICE_CLOSE              xSysdeviceClose;
  X_SYSDEVICE_GET_MBX_STATE      xSysdeviceGetMBXState;
  X_SYSDEVICE_PUT_PACKET         xSysdevicePutPacket;
  X_SYSDEVICE_GET_PACKET         xSysdeviceGetPacket;
  X_SYSDEVICE_INFO               xSysdeviceInfo;
  X_SYSDEVICE_FIND_FIRST_FILE    xSysdeviceFindFirstFile;
  X_SYSDEVICE_FIND_NEXT_FILE     xSysdeviceFindNextFile;
  X_SYSDEVICE_DOWNLOAD           xSysdeviceDownload;
  X_SYSDEVICE_UPLOAD             xSysdeviceUpload;
  X_SYSDEVICE_RESET              xSysdeviceReset;

  /* Channel depending functions */
  X_CHANNEL_OPEN                  xChannelOpen;
  X_CHANNEL_CLOSE                 xChannelClose;
  X_CHANNEL_FIND_FIRST_FILE       xChannelFindFirstFile;
  X_CHANNEL_FIND_NEXT_FILE        xChannelFindNextFile;
  X_CHANNEL_DOWNLOAD              xChannelDownload;
  X_CHANNEL_UPLOAD                xChannelUpload;
  X_CHANNEL_GET_MBX_STATE         xChannelGetMBXState;
  X_CHANNEL_PUT_PACKET            xChannelPutPacket;
  X_CHANNEL_GET_PACKET            xChannelGetPacket;
  X_CHANNEL_GET_SEND_PACKET       xChannelGetSendPacket;
  X_CHANNEL_CONFIG_LOCK           xChannelConfigLock;
  X_CHANNEL_RESET                 xChannelReset;
  X_CHANNEL_INFO                  xChannelInfo;
  X_CHANNEL_WATCHDOG              xChannelWatchdog;
  X_CHANNEL_HOST_STATE            xChannelHostState;
  X_CHANNEL_BUS_STATE             xChannelBusState;
  X_CHANNEL_DMA_STATE             xChannelDMAState;
  X_CHANNEL_IOINFO                xChannelIOInfo;
  X_CHANNEL_IOREAD                xChannelIORead;
  X_CHANNEL_IOWRITE               xChannelIOWrite;
  X_CHANNEL_IOREAD_SEND_DATA      xChannelIOReadSendData;
  X_CHANNEL_CONTROL_BLOCK         xChannelControlBlock;
  X_CHANNEL_COMMON_STATUS_BLOCK   xChannelCommonStatusBlock;
  X_CHANNEL_EXTENDED_STATUS_BLOCK xChannelExtendedStatusBlock;
  X_CHANNEL_USER_BLOCK            xChannelUserBlock;
  X_CHANNEL_PLC_MEMORYPTR         xChannelPLCMemoryPtr;
  X_CHANNEL_PLC_IS_READ_READY     xChannelPLCIsReadReady;
  X_CHANNEL_PLC_IS_WRITE_READY    xChannelPLCIsWriteReady;
  X_CHANNEL_PLC_ACTIVATE_WRITE    xChannelPLCActivateWrite;
  X_CHANNEL_PLC_ACTIVATE_READ     xChannelPLCActivateRead;

  NX_CON_CREATE_CONFIG_DIALOG     nxConCreateConfigDialog;
  NX_CON_CLOSE_CONFIG_DIALOG      nxConCloseConfigDialog;
  NX_CON_ENUMERATE                nxConEnumerate;

};